/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

#include <intrins.h>
#include "STC8Hxxxxx.h"

/*************	˵	**************

ͨ(P3.0 P3.1)ָô, Լȡֵ.

P1.0(TK00)   P1.1(TK01)   P5.4(TK02)   P1.3(TK03)   P1.4(TK04)   P1.5(TK05)   P1.6(TK06)   P1.7(TK07)
P5.0(TK08)   P5.1(TK09)   P5.2(TK10)   P5.3(TK11)   P0.0(TK12)   P0.1(TK13)   P0.2(TK14)   P0.3(TK15)

Ĭ: 115200,N,8,1.

ϵȶʱĶΪ.

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/


/*************	س	**************/

//ͬͺоƬڴ洢бĵַͬο7.3½
#define ID_ROMADDR          ((unsigned char code *)0xfdf9) 
#define VREF_ROMADDR        (*(unsigned int code *)0xfdf7)
#define F32K_ROMADDR        (*(unsigned int code *)0xfdf5)

#define T22M_ROMADDR        (*(unsigned char code *)0xfdf4)  //22.1184MHz (27MƵ)
#define T24M_ROMADDR        (*(unsigned char code *)0xfdf3)  //24MHz (27MƵ)
#define T20M_ROMADDR        (*(unsigned char code *)0xfdf2)  //20MHz (27MƵ)
#define T27M_ROMADDR        (*(unsigned char code *)0xfdf1)  //27MHz (27MƵ)
#define T30M_ROMADDR        (*(unsigned char code *)0xfdf0)  //30MHz (27MƵ)
#define T33M_ROMADDR        (*(unsigned char code *)0xfdef)  //33MHz (27MƵ)
#define T35M_ROMADDR        (*(unsigned char code *)0xfdee)  //35MHz (44MƵ)
#define T36M_ROMADDR        (*(unsigned char code *)0xfded)  //36MHz (44MƵ)
#define T40M_ROMADDR        (*(unsigned char code *)0xfdec)  //40MHz (44MƵ)
#define VRT6M_ROMADDR       (*(unsigned char code *)0xfdea)  //VRTRIM_6MHz
#define VRT10M_ROMADDR      (*(unsigned char code *)0xfde9)  //VRTRIM_10MHz
#define VRT27M_ROMADDR      (*(unsigned char code *)0xfde8)  //VRTRIM_27MHz
#define VRT44M_ROMADDR      (*(unsigned char code *)0xfde7)  //VRTRIM_44MHz

#define Baudrate            115200L

#define SYNC1		0x55
#define SYNC2		0x54

typedef enum
{
	CMD_SYNC1 = 0,/*0*/
	CMD_SYNC2,		/*1*/
	CMD_TYPE,			/*2*/
	CMD_TSCHEN1,	/*3*/
	CMD_TSCHEN2,	/*4*/
	CMD_TSCFG1,		/*5*/
	CMD_TSCFG2,		/*6*/
	CMD_TSCTRL,		/*7*/
	CMD_TSRT,			/*8*/
	CMD_SFREQ1,		/*9*/
	CMD_SFREQ2,		/*10*/
	CMD_TSWUTC,		/*11*/

	CMD_TSTH00H,
	CMD_TSTH00L,
	CMD_TSTH01H,
	CMD_TSTH01L,
	CMD_TSTH02H,
	CMD_TSTH02L,
	CMD_TSTH03H,
	CMD_TSTH03L,
	CMD_TSTH04H,
	CMD_TSTH04L,
	CMD_TSTH05H,
	CMD_TSTH05L,
	CMD_TSTH06H,
	CMD_TSTH06L,
	CMD_TSTH07H,
	CMD_TSTH07L,
	CMD_TSTH08H,
	CMD_TSTH08L,
	CMD_TSTH09H,
	CMD_TSTH09L,
	CMD_TSTH10H,
	CMD_TSTH10L,
	CMD_TSTH11H,
	CMD_TSTH11L,
	CMD_TSTH12H,
	CMD_TSTH12L,
	CMD_TSTH13H,
	CMD_TSTH13L,
	CMD_TSTH14H,
	CMD_TSTH14L,
	CMD_TSTH15H,
	CMD_TSTH15L,

	CMD_CS,
	CMD_LEN,
}CMD_IndexType;

typedef enum
{
	IRC_500K = 0,		/*0*/
	IRC_1M,
	IRC_2M,
	IRC_3M,
	IRC_5M,
	IRC_6M,
	IRC_8M,
	IRC_10M,
	IRC_11M,
	IRC_12M,
	IRC_15M,
	IRC_18M,
	IRC_20M,
	IRC_22M,
	IRC_24M,
	IRC_27M,
	IRC_30M,
	IRC_33M,
	IRC_35M,
	IRC_36M,
}IRC_IndexType;

/*************	IOڶ	**************/
sbit	P_RUN_LED = P3^4;

sbit	P_K0_LED  = P2^5;
sbit	P_K1_LED  = P0^7;
sbit	P_K2_LED  = P4^1;
sbit	P_K3_LED  = P2^1;
sbit	P_K4_LED  = P5^4;
sbit	P_K5_LED  = P4^6;
sbit	P_K6_LED  = P2^4;
sbit	P_K7_LED  = P0^5;
sbit	P_K8_LED  = P4^2;
sbit	P_K9_LED  = P4^3;
sbit	P_K10_LED = P2^3;
sbit	P_K11_LED = P4^5;
sbit	P_K12_LED = P2^0;
sbit	P_K13_LED = P2^7;
sbit	P_K14_LED = P2^6;
sbit	P_K15_LED = P0^6;

/*************	ر	**************/
u8 CLK_ID = IRC_22M;
u32 MAIN_Fosc =	22118400L;	//ʱ

bit	B_TX1_Busy;		// æ־
bit	B_Zero_Flag;
bit B_1ms;        //1ms־

u16	ChannelSet;

u8  TK_TimeOut;
u8	read_cnt;
u16	tpFlag;
u16	JudgeFlag;

u16	xdata TK_cnt[16]; 
u16	xdata TK_zero[16];

u16	xdata TK_differ[16];
u16	xdata TK_lowest[16];

u8	xdata Zero_Add_Cnt[16];
u8	xdata Zero_Sub_Cnt[16];
u8	xdata TK_counter[16];

u8	xdata SendBuffer[CMD_LEN];
u8  xdata RX1_Buffer[CMD_LEN];   //ջ

u8  RX1_TimeOut;
u8  RX1_Cnt;    //ռ
u16 ScanFreq;   //ɨƵ

               //TP0   TP1   TP2  TP3  TP4  TP5  TP6  TP7   TP8  TP9   TP10 TP11 TP12 TP13 TP14 TP15                      ֵ / 2
u16 code DIFF[]={1100, 1400, 800, 600, 1000, 850, 850, 1200, 850, 1000, 800, 900, 550, 600, 900, 1200};   //ֵ=(δֵ-ֵ)/2

/*************	غ	**************/

void	Timer0_init(u32 clk);
void	UART1_config(u32 clk, u32 brt);	//clk: ϵͳƵ brt: ͨŲ
void 	UART1_PrintString(u8 *puts);
void 	UART1_TxByte(u8 dat);
void  JudgeKey(u8 tkn);
void	RX1_Check(void);
void	ReadZeroData(void);
u8 GetCheckSum(u8 *buf, u8 len);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
	u8	i;
	
	P0M1 = 0x0f;   P0M0 = 0xe0;   //P0.0~P0.3Ϊ; P0.5~P0.7Ϊ
	P1M1 = 0xff;   P1M0 = 0x00;   //Ϊ
	P2M1 = 0x00;   P2M0 = 0xff;   //Ϊ
	P3M1 = 0x00;   P3M0 = 0x10;   //P3.4Ϊ
    P5M1 = 0x00;   P5M0 = 0x10;   //P5.4Ϊ
	P4M1 = 0x00;   P4M0 = 0x6e;   //P4.1~P4.3,P4.5,P4.6Ϊ
	P5M1 = 0x0f;   P5M0 = 0x00;   //P5.0~P5.3Ϊ

	P_RUN_LED = 1;
	P_K0_LED = 0;	P_K4_LED = 0;	P_K8_LED = 0;	P_K12_LED = 0;
	P_K1_LED = 0;	P_K5_LED = 0;	P_K9_LED = 0;	P_K13_LED = 0;
	P_K2_LED = 0;	P_K6_LED = 0;	P_K10_LED = 0;	P_K14_LED = 0;
	P_K3_LED = 0;	P_K7_LED = 0;	P_K11_LED = 0;	P_K15_LED = 0;
	Timer0_init(MAIN_Fosc/1000);	//Timer 0 жƵ, 1000/

	P_SW2 |= 0x80;	//XSF
//	MCLKOCR = 0x02;	//P5.4Ƶ/2

	TSRT = 0x00;		//ûLEDʱɨ
	TSCHEN1 = 0x10;	//TK00~TK07
	TSCHEN2 = 0x00;	//TK08~TK15
	TSCFG1  = (7<<4) + 3;	//صݹƵ = fosc/(2*(TSCFG1[6:4]+1)), ŵʱ(ϵͳʱ) 0(125) 1(250) 2(500) 3(1000) 4(2000) 5(2500) 6(5000) 7(7500) С3
	TSCFG2  = 2;				//ôڲοѹ(AVCCķѹ), 0(1/4)  1(1/2)  2(5/8)  3(3/4)
	TSCTRL = 0xA0;			//a0ʼԶɨ, ƽ, B7: TSGO,  B6: SINGLE,  B5: TSWAIT, B4: TSWUCS, B3: TSDCEN, B2: TSWUEN, B1 B0: TSSAMP
//	TSCTRL = (1<<7) + (1<<6);	//ʼɨ, ƽ
//	TSCTRL = (1<<7) + (1<<6)+3;	//ʼɨ, 4ƽ
//	TSCTRL = (1<<7) + (1<<6)+1;	//ʼɨ, 2ƽ
//	TSWUTC = 12;		//100msһ
	IE2 |= 0x80;			//ʹܴж
//	P_SW2 &= ~0x80;		//ֹxsf
	UART1_config(MAIN_Fosc, Baudrate);
	EA = 1;		//ȫж
	UART1_PrintString("STC8H4K64Txx Գ\r\n");

	for(i=0; i<16; i++)
	{
		TK_differ[i] = DIFF[i];	  //óʼֵ
		TK_lowest[i] = DIFF[i]*3;	//óʼֵ,  = ֵ*3
		TK_counter[i] = 0;
		Zero_Sub_Cnt[i] = 0;
		Zero_Add_Cnt[i] = 0;
	}
	tpFlag = 0;
	JudgeFlag = 0;
	read_cnt=0;
	TK_TimeOut = 0;
	B_Zero_Flag = 1;
	ChannelSet = ((u16)TSCHEN2 << 8) | TSCHEN1;

	ScanFreq = 50;		//Чʱ
	SendBuffer[0] = SYNC1;	//ʼͬͷ
	SendBuffer[1] = SYNC2;

	while (1)
	{
		ReadZeroData();
		
		if(B_1ms)
		{
			B_1ms = 0;

			for(i=0;i<16;i++)
			{
				JudgeKey(i);	//жϼֵ
			}

			B = (u8)tpFlag;
			if(B0)	P_K0_LED = ~P_K0_LED;
			if(B1)	P_K1_LED = ~P_K1_LED;
			if(B2)	P_K2_LED = ~P_K2_LED;
			if(B3)	P_K3_LED = ~P_K3_LED;
			if(B4)	P_K4_LED = ~P_K4_LED;
			if(B5)	P_K5_LED = ~P_K5_LED;
			if(B6)	P_K6_LED = ~P_K6_LED;
			if(B7)	P_K7_LED = ~P_K7_LED;
			B = (u8)(tpFlag >> 8);
			if(B0)	P_K8_LED  = ~P_K8_LED;
			if(B1)	P_K9_LED  = ~P_K9_LED;
			if(B2)	P_K10_LED = ~P_K10_LED;
			if(B3)	P_K11_LED = ~P_K11_LED;
			if(B4)	P_K12_LED = ~P_K12_LED;
			if(B5)	P_K13_LED = ~P_K13_LED;
			if(B6)	P_K14_LED = ~P_K14_LED;
			if(B7)	P_K15_LED = ~P_K15_LED;

			tpFlag = 0;
			
			if(RX1_TimeOut > 0)
			{ 
				if(--RX1_TimeOut == 0)  //ʱ,򴮿ڽս
				{  
					if(RX1_Cnt > 0)
					{
						RX1_Check();    //1
					}
					RX1_Cnt = 0;
				}
			}
		}
	}
}

//========================================================================
// : void JudgeKey(u8 tkn)
// : жϼֵǷЧ
// : tkn: .
// : none.
// 汾: VER1.0
// : 2010-12-15
// ע: 
//========================================================================
void JudgeKey(u8 tkn)
{
	if(tkn > 15) return;		//Ŵ
	
	if(ChannelSet & (1<<tkn))
	{
		if(TK_cnt[tkn] > TK_zero[tkn])
		{
			Zero_Sub_Cnt[tkn] = 0;
			if(Zero_Add_Cnt[tkn] < 10)
			{
				Zero_Add_Cnt[tkn]++;
			}
			else
			{
				TK_zero[tkn] += 1;		//׷
			}
			
			if(TK_counter[tkn] > 0)
			{
				TK_counter[tkn]--;
			}
			else
			{
				JudgeFlag &= ~(1<<tkn);	//־
				tpFlag &= ~(1<<tkn);	//־
			}
		}
		else if(TK_cnt[tkn] <= (TK_zero[tkn]-TK_differ[tkn]))	//жϼֵ.
		{
			Zero_Sub_Cnt[tkn] = 0;
			Zero_Add_Cnt[tkn] = 0;
			if(TK_cnt[tkn] <= (TK_zero[tkn]-TK_lowest[tkn]))	//ֵ.
			{
				//ֵΧжΪ
				TK_counter[tkn] = 0;
			}
			else if((JudgeFlag & (1<<tkn)) == 0)
			{
				TK_counter[tkn]++;
				if(TK_counter[tkn] > ScanFreq)
				{
					JudgeFlag |= (1<<tkn);	//ô־
					tpFlag |= (1<<tkn);
				}
			}
		}
		else
		{
			Zero_Add_Cnt[tkn] = 0;
			if(Zero_Sub_Cnt[tkn] < 100 )	//ӻ׷
			{
				Zero_Sub_Cnt[tkn]++;
			}
			else
			{
				if(TK_cnt[tkn] < TK_zero[tkn])	//ӻ׷
				{
					TK_zero[tkn] -= 1;		//׷
					Zero_Sub_Cnt[tkn] = 0;
				}
			}

			if(TK_counter[tkn] > 0)
			{
				TK_counter[tkn]--;
			}
			else
			{
				JudgeFlag &= ~(1<<tkn);	//־
				tpFlag &= ~(1<<tkn);	//־
			}
		}
	}
}

//========================================================================
// : void ReadZeroData(void)
// : ȡֵ
// : none.
// : none.
// 汾: VER1.0
// : 2021-02-02
// ע: 
//========================================================================
void ReadZeroData(void)
{
	u8 i;
	if(B_Zero_Flag)
	{
		TK_TimeOut++;
		if(TK_TimeOut > 250)	//ɨ賬ʱ
		{
			TK_TimeOut = 0;
			read_cnt++;
		}
		
		if(read_cnt > 100)
		{
			for(i=0; i<16; i++)
			{
				TK_zero[i] = TK_cnt[i];	//0
				TK_counter[i] = 0;
			}
			B_Zero_Flag = 0;
		}
	}
}

//========================================================================
// : void	UART1_config(u32 clk, u32 brt)
// : UART1ʼ
// : clk: ϵͳƵ.
//       brt: ͨŲ.
// : none.
// 汾: VER1.0
// : 2021-7-29
// ע: 
//========================================================================
void	UART1_config(u32 clk, u32 brt)
{
	brt = 65536UL - (clk / 4) / brt;
	TR1 = 0;
	AUXR &= ~0x01;		//S1 BRT Use Timer1;
	AUXR |=  (1<<6);	//Timer1 set as 1T mode
	TMOD &= ~(1<<6);	//Timer1 set As Timer
	TMOD &= ~0x30;		//Timer1_16bitAutoReload;
	TH1 = (u8)(brt >> 8);
	TL1 = (u8)brt;
	ET1 = 0;			// ֹTimer1ж
	INTCLKO &= ~0x02;	// Timer1ʱ
	TR1  = 1;			// Timer1

	P_SW1 &= 0x3f;
	P_SW1 |= 0x00;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

	SCON = (SCON & 0x3f) | (1<<6);	// 8λ, 1λʼλ, 1λֹͣλ, У
//	PS  = 1;	//ȼж
	ES  = 1;	//ж
	REN = 1;	//

	B_TX1_Busy = 0;
	RX1_Cnt = 0;
}

//========================================================================
// : void UART1_TxByte(u8 dat)
// : 1һֽں
// : dat: Ҫ͵.
// : none.
// 汾: VER1.0
// : 2018-4-2
// ע: 
//========================================================================
void UART1_TxByte(u8 dat)
{
	B_TX1_Busy = 1;			//־æ
	SBUF = dat;					//һֽ
	while(B_TX1_Busy);	//ȴ
}

//========================================================================
// : void UART1_PrintString(u8 *puts)
// : 1ַӡ
// : puts: ַָ.
// : none.
// 汾: VER1.0
// : 2018-4-2
// ע: 
//========================================================================
void UART1_PrintString(u8 *puts)
{
	for (; *puts != 0;	puts++)
	{
		UART1_TxByte(*puts);
	}
}

//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : 1жϺ
// : none.
// : none.
// 汾: VER1.0
// : 2018-4-2
// ע: 
//========================================================================
void UART1_int (void) interrupt UART1_VECTOR
{
	if(RI)
	{
		RI = 0;
		if(RX1_Cnt >= CMD_LEN) RX1_Cnt = 0;
		RX1_Buffer[RX1_Cnt] = SBUF;
		RX1_Cnt++;
		RX1_TimeOut = 5;
	}

	if(TI)
	{
		TI = 0;
		B_TX1_Busy = 0;
	}
}

//========================================================================
// : void Timer0_init(void)
// : timer0ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer0_init(u32 clk)
{
	TR0 = 0;    //ֹͣ

	ET0 = 1;    //ж
//  PT0 = 1;    //ȼж
	TMOD &= ~0x03;
	TMOD |= 0;  //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
//  TMOD |=  0x04;  //Ƶ
	TMOD &= ~0x04;  //ʱ
//  INTCLKO |=  0x01;  //ʱ
	INTCLKO &= ~0x01;  //ʱ

	if (clk < 65536UL)
	{
		AUXR |=  0x80;  //1T mode
		TH0 = (u8)((65536UL - clk) / 256);
		TL0 = (u8)((65536UL - clk) % 256);
	}
	else
	{
		AUXR &= ~0x80;  //12T mode
		TH0 = (u8)((65536UL - clk/12) / 256);
		TL0 = (u8)((65536UL - clk/12) % 256);
	}

	TR0 = 1;    //ʼ
}

//========================================================================
// : void timer0_int (void) interrupt TIMER0_VECTOR
// :  timer0жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void timer0_int (void) interrupt 1
{
	B_1ms = 1;      //1ms־
}

//========================================================================
// : void SetMCLK(u8 clk)
// : Ƶ
// : clk: Ƶ
// : none.
// 汾: VER1.0
// : 2020-10-21
// ע: 
//========================================================================
void SetMCLK(u8 clk) //Ƶ
{
	if(clk > IRC_36M) return;	//Error
	CLK_ID = clk;
	switch(clk)
	{
	case IRC_500K:
		//ѡ500KHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 48;
		MAIN_Fosc =	500000L;	//ʱ
		break;

	case IRC_1M:
		//ѡ1MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 24;
		MAIN_Fosc =	1000000L;	//ʱ
		break;

	case IRC_2M:
		//ѡ2MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 12;
		MAIN_Fosc =	2000000L;	//ʱ
		break;

	case IRC_3M:
		//ѡ3MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 8;
		MAIN_Fosc =	3000000L;	//ʱ
		break;

	case IRC_5M:
		//ѡ5.5296MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T22M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 4;
		MAIN_Fosc =	5529600L;	//ʱ
		break;

	case IRC_6M:
		//ѡ6MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 4;
		MAIN_Fosc =	6000000L;	//ʱ
		break;

	case IRC_8M:
		//ѡ8MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 3;
		MAIN_Fosc =	8000000L;	//ʱ
		break;

	case IRC_10M:
		//ѡ10MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T20M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 2;
		MAIN_Fosc =	10000000L;	//ʱ
		break;

	case IRC_11M:
		//ѡ11.0592MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T22M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 2;
		MAIN_Fosc =	11059200L;	//ʱ
		break;

	case IRC_12M:
		//ѡ12MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 2;
		MAIN_Fosc =	12000000L;	//ʱ
		break;

	case IRC_15M:
		//ѡ15MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T30M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 2;
		MAIN_Fosc =	15000000L;	//ʱ
		break;

	case IRC_18M:
		//ѡ18.432MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T36M_ROMADDR;
		VRTRIM = VRT44M_ROMADDR;
		IRCBAND = 0x03;
		CLKDIV = 2;
		MAIN_Fosc =	18432000L;	//ʱ
		break;

	case IRC_20M:
		//ѡ20MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T20M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 0;
		MAIN_Fosc =	20000000L;	//ʱ
		break;

	case IRC_24M:
		//ѡ24MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T24M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 0;
		MAIN_Fosc =	24000000L;	//ʱ
		break;

	case IRC_27M:
		//ѡ27MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T27M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 0;
		MAIN_Fosc =	27000000L;	//ʱ
		break;

	case IRC_30M:
		//ѡ30MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T30M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 0;
		MAIN_Fosc =	30000000L;	//ʱ
		break;

	case IRC_33M:
		//ѡ33.1176MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T33M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 0;
		MAIN_Fosc =	33117600L;	//ʱ
		break;

	case IRC_35M:
		//ѡ35MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T35M_ROMADDR;
		VRTRIM = VRT44M_ROMADDR;
		IRCBAND = 0x03;
		CLKDIV = 0;
		MAIN_Fosc =	35000000L;	//ʱ
		break;

	case IRC_36M:
		//ѡ36.864MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T36M_ROMADDR;
		VRTRIM = VRT44M_ROMADDR;
		IRCBAND = 0x03;
		CLKDIV = 0;
		MAIN_Fosc =	36864000L;	//ʱ
		break;

	default:
		//ѡ22.1184MHz
		//P_SW2 = 0x80;
		CLKDIV = 0x04;
		IRTRIM = T22M_ROMADDR;
		VRTRIM = VRT27M_ROMADDR;
		IRCBAND = 0x02;
		CLKDIV = 0;
		MAIN_Fosc =	22118400L;	//ʱ
		break;
	}
	Timer0_init(MAIN_Fosc/1000);
	UART1_config(MAIN_Fosc, Baudrate);		// brt: ͨŲ.
}

//========================================================================
// : u8 GetCheckSum(u8 *buf, u8 len)
// : ȡУ
// : buf:  ַָ, len: ֽ
// : none.
// 汾: VER1.0
// : 2020-7-6
// ע: 
//========================================================================
u8 GetCheckSum(u8 *buf, u8 len) //ȡУ
{
    u8 i;
    u8 cs=0;
    for (i = 0; i < len; i++)
    {
        cs += buf[i];
    }
    return cs;
}

//========================================================================
// : void RX1_Check(void)
// : ڻȡ
// : none.
// : none.
// 汾: VER1.0
// : 2020-7-6
// ע: 
//========================================================================
void RX1_Check(void)
{
	u8  i;
	u16  tmpValue;

	if((RX1_Cnt >= 5) && (RX1_Buffer[CMD_SYNC1] == SYNC1) && (RX1_Buffer[CMD_SYNC2] == SYNC2))   //Ϊ10ֽ
	{
		if(RX1_Buffer[CMD_TYPE] == 0x01)	//λָͨЭ
		{
			if(RX1_Buffer[CMD_CS] == GetCheckSum(RX1_Buffer,CMD_CS))
			{
				P_SW2 |= 0x80;	//XSF
				IE2 &= 0x7F;		//ֹͣж
				TSCTRL = 0;			//ֹͣԶɨ
				TSSTA2 |= 0xc0;	//־λ
				TSRT = RX1_Buffer[CMD_TSRT];			//LEDʱɨ
				TSCHEN1 = RX1_Buffer[CMD_TSCHEN1];	//TK00~TK07
				TSCHEN2 = RX1_Buffer[CMD_TSCHEN2];	//TK08~TK15
				TSCFG1 = RX1_Buffer[CMD_TSCFG1];		//صݹƵ = fosc/(2*(TSCFG1[6:4]+1)), ŵʱ(ϵͳʱ) 0(125) 1(250) 2(500) 3(1000) 4(2000) 5(2500) 6(5000) 7(7500) С3
				TSCFG2 = RX1_Buffer[CMD_TSCFG2];		//ôڲοѹ(AVCCķѹ), 0(1/4)  1(1/2)  2(5/8)  3(3/4)
				TSCTRL = RX1_Buffer[CMD_TSCTRL];	//ʼԶɨ, ƽ, B7: TSGO,  B6: SINGLE,  B5: TSWAIT, B4: TSWUCS, B3: TSDCEN, B2: TSWUEN, B1 B0: TSSAMP
				TSWUTC = RX1_Buffer[CMD_TSWUTC];
				ScanFreq = ((u16)RX1_Buffer[CMD_SFREQ1] << 8) + RX1_Buffer[CMD_SFREQ2];
				ChannelSet = ((u16)TSCHEN2 << 8) | TSCHEN1;
				IE2 |= 0x80;		//ʹܴж
//				P_SW2 &= ~0x80;		//ֹxsf
				
				for(i=0;i<16;i++)
				{
					tmpValue = (RX1_Buffer[CMD_TSTH00H+(i*2)] << 8) + RX1_Buffer[CMD_TSTH00L+(i*2)];
					if(tmpValue > 200)	//жϲֵǷЧ
					{
						TK_differ[i] = tmpValue >> 1;	//ֵ = ֵ/2
						TK_lowest[i] = TK_differ[i] * 3;
					}
				}
				
				read_cnt=0;
				TK_TimeOut = 0;
				B_Zero_Flag = 1;	//»ȡ0
			}
		}
		else if((RX1_Buffer[CMD_TYPE] == 0x02) && (RX1_Buffer[4] == GetCheckSum(RX1_Buffer,4)))
		{
			if(RX1_Buffer[3] < 16)		//MCUظ
			{
				SendBuffer[2] = 0x03;
				SendBuffer[3] = RX1_Buffer[3];
				SendBuffer[4] = (u8)(TK_cnt[RX1_Buffer[3]] >> 8);
				SendBuffer[5] = (u8)TK_cnt[RX1_Buffer[3]];
				SendBuffer[6] = (u8)(TK_zero[RX1_Buffer[3]] >> 8);
				SendBuffer[7] = (u8)TK_zero[RX1_Buffer[3]];
				SendBuffer[8] = GetCheckSum(SendBuffer,8);
				
				for(i=0;i<9;i++)
				{
					UART1_TxByte(SendBuffer[i]);
				}
			}
			else if(RX1_Buffer[3] == 0xfd)	//MCUظƵ
			{
				SendBuffer[2] = 0x03;
				SendBuffer[3] = RX1_Buffer[3];
				SendBuffer[4] = CLK_ID;
				SendBuffer[5] = GetCheckSum(SendBuffer,5);
				
				for(i=0;i<6;i++)
				{
					UART1_TxByte(SendBuffer[i]);
				}
			}
			else if(RX1_Buffer[3] == 0xfe)	//MCUظ״̬
			{
				P_SW2 |= 0x80;	//XSF
				SendBuffer[CMD_TYPE] = 0x04;
				SendBuffer[CMD_TSCHEN1] = TSCHEN1;
				SendBuffer[CMD_TSCHEN2] = TSCHEN2;
				SendBuffer[CMD_TSCFG1] = TSCFG1;
				SendBuffer[CMD_TSCFG2] = TSCFG2;
				SendBuffer[CMD_TSCTRL] = TSCTRL;
				SendBuffer[CMD_TSRT] = TSRT;
				SendBuffer[CMD_SFREQ1] = (u8)(ScanFreq >> 8);
				SendBuffer[CMD_SFREQ2] = (u8)ScanFreq;
				SendBuffer[CMD_TSWUTC] = TSWUTC;
//				P_SW2 &= ~0x80;		//ֹxsf

				for(i=0;i<16;i++)
				{
					tmpValue = TK_differ[i] << 1;		//ֵ = ֵ*2
					SendBuffer[CMD_TSTH00H+(i*2)] = (u8)(tmpValue >> 8);
					SendBuffer[CMD_TSTH00L+(i*2)] = (u8)tmpValue;
				}
				SendBuffer[CMD_CS] = GetCheckSum(SendBuffer,CMD_CS);

				for(i=0;i<CMD_LEN;i++)
				{
					UART1_TxByte(SendBuffer[i]);
				}
			}
		}
		else if((RX1_Buffer[CMD_TYPE] == 0x05) && (RX1_Buffer[4] == GetCheckSum(RX1_Buffer,4)))	//λƵָ
		{
			SetMCLK(RX1_Buffer[3]);
		}
	}
}

//========================================================================
// : void TKSU_Interrupt(void)
// : жϡ
// : none.
// : none.
// 汾: VER1.0
// : 2021-02-01
// ע: 
//========================================================================
void TKSU_Interrupt(void) interrupt 13
{
	u8	j;
	j = TSSTA2;
	if(j & 0x40)	//, ()
	{
		TSSTA2 |= 0x40;	//д1
	}
	if(j & 0x80)	//ɨ
	{
		j &= 0x0f;
		TK_cnt[j] = TSDAT;	//ĳͨĶ
		TSSTA2 |= 0x80;	//д1
		read_cnt++;		//+1, ʱ
		TK_TimeOut = 0;
	}
}